---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-Streaming Overview（DStreamsストリーミング概要）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` 行37-554
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` 行28-48
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.18
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.18
- E-05: `docs/code-to-docs/画面遷移図.md` DStreamTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/streaming/ | E-02 行29: SparkUITab(sparkUI, "streaming") | ○ |
| C-02 | デフォルトページ | E-01 行75: WebUIPage("") | ○ |
| C-03 | listener.synchronizedでデータ取得 | E-01 行90-93 | ○ |
| C-04 | 基本情報にBatch Duration/Running Time/Start Time/Completed Batches/Records | E-01 行124-141 | ○ |
| C-05 | Input Rateグラフ | E-01 行179-181, 212-222, 298-303 | ○ |
| C-06 | Scheduling Delayグラフ | E-01 行183-185, 224-233, 311-319 | ○ |
| C-07 | Processing Timeグラフ（バッチインターバル基準線あり） | E-01 行186-188, 235-245: Some(batchInterval) | ○ |
| C-08 | Total Delayグラフ | E-01 行189-191, 247-257 | ○ |
| C-09 | Input DStreamsテーブル展開機能 | E-01 行281-289: expand-input-rate | ○ |
| C-10 | レシーバー情報（Status/Executor/Error）表示 | E-01 行394-411: receiverInfo | ○ |
| C-11 | Running/Waiting/Completedバッチ一覧 | E-01 行471-537: generateBatchListTables | ○ |
| C-12 | 時間単位の動的正規化 | E-01 行200: UIUtils.normalizeDuration | ○ |
| C-13 | タイムラインクリックでバッチ詳細遷移 | E-01 行109-121: onClickTimeline | ○ |
| C-14 | D3.js使用 | E-01 行102 | ○ |
| C-15 | streaming-page.css/js使用 | E-01 行103-104 | ○ |
| C-16 | ページタイトルは"Streaming Statistics" | E-01 行94 | ○ |
| C-17 | レシーバー数表示 | E-01 行293-297: numActiveReceivers / numReceivers | ○ |
| C-18 | セクション折りたたみ機能 | E-01 行479-495: collapseTable | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面仕様がソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] DStreams APIがレガシーであることの記述が適切か確認
- [ ] バッチインターバル基準線の表示が正しいか実機確認
